function [CA, CAl, CAr]=centroidIT2(A)

% To compute the centroid of an IT2 FS, where that FS is defined by nine
% parameters (a, b, c, d, e, f, g, i, h) shown in Fig. 1 of Readme.doc. It is 
% used in getFOUs.m to ranking the 32 word FOUs [1] obtained from survey 
% data (datacopy.xls).
%
% [1] Dongrui Wu and Jerry M. Mendel, A comparative study of ranking methods, 
% similarity measures and uncertainty measures for interval type-2 fuzzy sets, 
% submitted to Information Sciences, 2008.
%
% Dongrui WU (dongruiw@usc.edu), 5/12/2008
%
% A: an IT2 FS represented by 9 parameters.
% CA: center of centroid of A
% CAl: left bound of the centroid
% CAr: right bound of the centroid

N=200; % number of discretizations
dx=(A(4)-A(1))/N;  

for j=1:N+1
    x=A(1)+(j-1)*dx;
    
    if x<=A(1)| x>=A(4)
        upperA(j)=0;
    elseif  x<A(2)
        upperA(j)=(x-A(1))/(A(2)-A(1));
    elseif  x<=A(3);
        upperA(j)=1;
    else 
        upperA(j)=(A(4)-x)/(A(4)-A(3));
    end
    
    if x<=A(5) | x>=A(8)
        lowerA(j)=0;
    elseif x<A(6)
        lowerA(j)=A(9)*(x-A(5))/(A(6)-A(5));
    elseif x<A(7)
        lowerA(j)=A(9);
    else
        lowerA(j)=A(9)*(A(8)-x)/(A(8)-A(7));
    end
end

%% centroid of A
CAl=EKM(A(1)+[0:N]*dx,lowerA,upperA,-1);
CAr=EKM(A(1)+[0:N]*dx,lowerA,upperA,1);
CA=(CAl+CAr)/2;
